﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
//for the Arduino Serial project
using System.Diagnostics;
using System.Drawing;
using System.IO.Ports;
using System.Linq;
using System.Media;
using System.Security.Cryptography;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Atroidinator2_Dominik
{
    public partial class fmArduinoSerialConnect : Form
    {
        fmLogging fmLoggingWindow = new fmLogging();

        private delegate void SafeCallDelegate();

        String receivedString = "";
        String receivedStringLast = "";

        public fmArduinoSerialConnect()
        {
            InitializeComponent();
        }

        private void fmArduinoSerialConnect_Load(object sender, EventArgs e)
        {
            tmrMain.Enabled = false;
            this.Text = Application.ProductName;

            this.Left = 100;
            this.Top = 100;

            InitTabs();

            serialPortArduinoConnection.DataReceived += serialPortArduinoConnection_DataReceived;
        }

        private void InitTabs()
        {
            //setup the tabcontrol that the tabs will not show, dirty trick but..
            tbcMain.Appearance = TabAppearance.FlatButtons;
            tbcMain.ItemSize = new Size(0, 1);
            tbcMain.SizeMode = TabSizeMode.Fixed;
            tbcMain.SelectedTab = tbpStartUpScreen;
        }

        #region Serial Handling and basics
        public void PrintLn(string a_text, string a_color)
        {
            string m_color;

            m_color = a_color.ToUpper();//eliminate a possible problem of the letter casing
            rtbLogging.BeginInvoke((MethodInvoker)delegate
            {
                switch (a_color.ToUpper())
                {
                    case "R": rtbLogging.SelectionColor = Color.Red; break;
                    case "G": rtbLogging.SelectionColor = Color.Green; break;
                    case "B": rtbLogging.SelectionColor = Color.Blue; break;
                    case "Y": rtbLogging.SelectionColor = Color.Orange; break;
                    default: rtbLogging.SelectionColor = Color.Black; break;
                }

                rtbLogging.AppendText(a_text + "\n");
                rtbLogging.ScrollToCaret();
            });
        }


        private void btnScanPortsDkal_Click(object sender, EventArgs e)
        {
            ScanComPortsDkal();
        }

        private void ScanComPortsDkal()
        {
            String[] ports = SerialPort.GetPortNames();
            Array.Sort(ports);
            string m_portWithOutLastCharacter;

            if (serialPortArduinoConnection.IsOpen)
            {
                PrintLn("Connection was open. Closing..", "B");
                serialPortArduinoConnection.Close();
            }
            cbbSerialPortsDkal.Items.Clear();

            foreach (String port in ports)
            {
                if (cbSelectIfDangerShieldIsUsed.Checked == true)
                {
                    m_portWithOutLastCharacter = port.Substring(0, port.Length - 1);
                }
                else
                {
                    m_portWithOutLastCharacter = port;
                }

                cbbSerialPortsDkal.Items.Add(m_portWithOutLastCharacter);
                PrintLn("Found port:" + m_portWithOutLastCharacter.ToString(), "W");
            }

        }

        private void btnSerialPortOpenDkal_Click(object sender, EventArgs e)
        {
            if (!serialPortArduinoConnection.IsOpen)
            {
                try
                {
                    serialPortArduinoConnection.Open();

                    Thread.Sleep(200); //wait 100 ms to open port

                    this.Text = "Main - using com port: " + cbbSerialPortsDkal.Text;
                    PrintLn("Using com port: " + cbbSerialPortsDkal.Text, "W");
                }
                catch
                {
                    //MessageBox.Show("ERROR. Please make sure that the correct port was selected, and the device, plugged in.", "Serial port", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    PrintLn("ERROR: Please make sure that the correct port was selected, and the device, plugged in.", "R");
                }
            }
        }

        private void cbbSerialPortsDkal_SelectedIndexChanged(object sender, EventArgs e)
        {
            serialPortArduinoConnection.PortName = cbbSerialPortsDkal.Text;

            PrintLn("Port selected: " + serialPortArduinoConnection.PortName, "W");
            PrintLn("Default baudrate: " + serialPortArduinoConnection.BaudRate.ToString(), "W");

            cbbBaudRateDkal.Text = serialPortArduinoConnection.BaudRate.ToString();

        }

        private void cbbBaudRateDkal_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (cbbBaudRateDkal.Text != "select..")
            {
                serialPortArduinoConnection.BaudRate = Convert.ToInt32(cbbBaudRateDkal.Text);
                btnSerialPortOpenDkal.Enabled = true;
                PrintLn("Selected baudrate: " + serialPortArduinoConnection.BaudRate.ToString(), "W");
            }
            else
            {
                PrintLn("ERROR: Select the correct baudrate!", "R");
            }
        }

        public void WriteArduino(string a_action)
        {
            int m_length = a_action.Length;
            char[] m_data = new char[m_length];

            String m_carriageReturn = "\r";
            char[] m_cr = new char[2];

            String m_newLine = "\n";
            char[] m_nl = new char[2];

            for (int m_index = 0; m_index < m_length; m_index++)
            {
                m_data[m_index] = Convert.ToChar(a_action[m_index]);
            }

            for (int m_index = 0; m_index < 1; m_index++)
            {
                m_cr[m_index] = Convert.ToChar(m_carriageReturn[m_index]);
            }

            for (int m_index = 0; m_index < 1; m_index++)
            {
                m_nl[m_index] = Convert.ToChar(m_newLine[m_index]);
            }

            if (serialPortArduinoConnection.IsOpen == true)
            {
                serialPortArduinoConnection.Write(m_data, 0, m_length);

                if (cbxCarriageReturn.Checked == true)
                {
                    serialPortArduinoConnection.Write(m_cr, 0, 2);
                }

                if (cbxNewLine.Checked == true)
                {
                    serialPortArduinoConnection.Write(m_nl, 0, 2);
                }

                PrintLn("Transmitted message from Main: " + a_action, "Y");
            }
            else
            {
                //MessageBox.Show("ERROR. Please make sure that the correct port was selected, and the device, plugged in.", "Serial port", MessageBoxButtons.OK, MessageBoxIcon.Error);
                PrintLn("ERROR. Please make sure that the correct port was selected, and the device, plugged in.", "R");
            }
        }
        private void serialPortArduinoConnection_DataReceived(object sender, SerialDataReceivedEventArgs e)
        {
            try
            {
                string receivedData = serialPortArduinoConnection.ReadLine().Trim(); // Lees de seriële data

                // Voorkom threading problemen
                this.Invoke((MethodInvoker)delegate
                {
                    ProcessArduinoInput(receivedData);
                    PrintLn(receivedData, "G");
                    receivedString = receivedData;
                });
            }
            catch (Exception ex)
            {
                PrintLn("ERROR: " + ex.Message, "R");
            }
        }


        public string ReadArduino()
        {
            UpdateReceivedString();

            return receivedString;
        }


        private void UpdateReceivedString()
        {
            if (receivedString != receivedStringLast)
            {
                PrintLn(receivedString, "G");
            }

            receivedStringLast = receivedString;
        }

        private void rtbLogging_DoubleClick(object sender, EventArgs e)
        {
            rtbLogging.Clear();
        }

        private void btClearInOutBuffer_Click(object sender, EventArgs e)
        {
            serialPortArduinoConnection.DiscardInBuffer();
            serialPortArduinoConnection.DiscardOutBuffer();

            PrintLn("IN and out buffers discarded", "B");
        }

        private void btnAboutDkal_Click(object sender, EventArgs e)
        {
            MessageBox.Show("Created by : Dick van Kalsbeek\n" +
                            "Initial: 14aug2020\n" +
                            "Last update: 06mrt2024 by GEST\n" +
                            "Information: basic application to send to and receive from Arduino",
                            "About..", MessageBoxButtons.OK, MessageBoxIcon.Information);
        }

        private void btnStartApplication_Click(object sender, EventArgs e)
        {
            tbcMain.SelectedTab = tbpSerCom;
        }
        private void msiLogging_Click(object sender, EventArgs e)
        {
            if (msiLogging.Checked)
            {
                fmLoggingWindow.Show();
                msiLogging.Text = "Logging*";
            }
            else
            {
                fmLoggingWindow.Hide();
                msiLogging.Text = "Logging";
            }
            tmrMain.Stop();
            tmrMain.Stop();
        }

        private void msiScaQuit_Click(object sender, EventArgs e)
        {
            DialogResult = MessageBox.Show("Clicking OK will close the application. Since nothing is saved your work will be lost.",
                                                "Quit?", MessageBoxButtons.OKCancel, MessageBoxIcon.Warning);
            if (DialogResult == DialogResult.OK)
            {
                Application.Exit();
            }
            tmrMain.Stop(); // Pauzeer de game-loop als een andere tab wordt geopend
            this.Height = 393;

        }

        private void msiViewTestGround_Click(object sender, EventArgs e)
        {
            tbcMain.SelectedTab = tbpTestGround;
            this.Size = DefaultFormSize;
        }

        private void msiViewCustom_Click(object sender, EventArgs e)
        {
            tbcMain.SelectedTab = tbpCustomApplication;
            this.Size = CustomGameSize;

        }

        private void msiHelp_Click(object sender, EventArgs e)
        {
            tmrMain.Stop();
        }

        private void msiQuickGuide_Click(object sender, EventArgs e)
        {
            tbcMain.SelectedTab = tbpQuickGuide;
            this.Height = 393;
        }

        private void msiViewSerialCommunication_Click(object sender, EventArgs e)
        {
            tbcMain.SelectedTab = tbpSerCom;
            this.Size = DefaultFormSize;
        }
        #endregion

        //THIS WAY THE REGION BOUNDARIES CAN BE FOUND EASIER

        #region Test Ground

        private void btnWrite_Click(object sender, EventArgs e)
        {
            ExecuteWriteAfterEnter();
        }

        private void ExecuteWriteAfterEnter()
        {
            WriteArduino(txbWriteCustom.Text);
        }

        private void btnRead_Click(object sender, EventArgs e)
        {
            lblReturned.Text = ReadArduino();
        }


        private void btnWriteDefault_Click(object sender, EventArgs e)
        {
            String m_testText = "Test";

            WriteArduino(m_testText);
            lblSent.Text = m_testText;
        }

        private void btnResetArduino_Click(object sender, EventArgs e)
        {
            WriteArduino("Reset");
        }

        private void txbWriteCustom_KeyUp(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Enter)
            {
                ExecuteWriteAfterEnter();
            }
        }




        #endregion

        //THIS WAY THE REGION BOUNDARIES CAN BE FOUND EASIER

        #region Custom

        private int moveSpeed = 5;
        private int playerLives = 3;

        private int enemiesHit = 0;
        private int shotsFired = 0;
        private int Accuracy = 0;

        private bool movingUp = false;
        private bool movingDown = false;
        private bool movingLeft = false;
        private bool movingRight = false;

        private bool isCtrlPressed = false;
        private bool isEPressed = false;
        private bool isShiftPressed = false;

        private List<Bullet> bullets = new List<Bullet>();
        private int bulletSpeed = 10;

        private List<Enemy> enemies = new List<Enemy>();
        private Random random = new Random();

        private readonly Size DefaultFormSize = new Size(657, 393);
        private readonly Size CustomGameSize = new Size(657, 500);

        //Setting up the bool
        private void ProcessArduinoInput(string input)
        {
            movingUp = false;
            movingDown = false;
            movingLeft = false;
            movingRight = false;

            switch (input)
            {
                case "Up": movingUp = true; break;
                case "Down": movingDown = true; break;
                case "Left": movingLeft = true; break;
                case "Right": movingRight = true; break;
            }
        }

        // Stuff that constantly needs to be happening.
        private void tmrMain_Tick(object sender, EventArgs e)
        {
            moveFlak();
            MoveBullets();
            SpawnEnemies();
            MoveEnemies();
            DetectBulletCollison();
            Calculations();
        }

        // The calculations for accuracy, enemieshit and shotsfired.
        private void Calculations()
        {
            if (enemiesHit > 0 && shotsFired > 0)
            {
                Accuracy = 100 * enemiesHit / shotsFired;
            }
            lblEnemiesShotDdeb.Text = enemiesHit.ToString();
            lblBulletsFiredDdeb.Text = shotsFired.ToString();
            lblAccuracyDdeb.Text = Accuracy.ToString();
        }

        // Movement of the flak
        private void moveFlak()
        {
            if (movingUp && pbxFlakDdeb.Top > 0)
            {
                pbxFlakDdeb.Top -= moveSpeed;
            }
            if (movingDown && tbpCustomApplication.Height > pbxFlakDdeb.Bottom)
            {
                pbxFlakDdeb.Top += moveSpeed;
            }
            if (movingRight && tbpCustomApplication.Width > pbxFlakDdeb.Right)
            {
                pbxFlakDdeb.Left += moveSpeed;
            }
            if (movingLeft && pbxFlakDdeb.Left > 0)
            {
                pbxFlakDdeb.Left -= moveSpeed;
            }
        }
        
        // Things that need to happen if a certain key is being PRESSED
        private void fmArduinoSerialConnect_KeyDown(object sender, KeyEventArgs e)
        {
            if ((e.KeyCode == Keys.W))
            {
                movingUp = true;
            }
            if (e.KeyCode == Keys.S)
            {
                movingDown = true;
            }
            if (e.KeyCode == Keys.A)
            {
                movingLeft = true;
            }
            if (e.KeyCode == Keys.D)
            {
                movingRight = true;
            }

            if (e.KeyCode == Keys.ControlKey) isCtrlPressed = true;
            if (e.KeyCode == Keys.E) isEPressed = true;

            if (isCtrlPressed && isEPressed)
            {
                ClearAllEnemies();
            }

            if (e.KeyCode == Keys.ShiftKey) isShiftPressed = true;

            if (isShiftPressed)
            {
                bulletSpeed = 20;
            }
        }

        // Things that need to happen if a certain key is being RELEASED
        private void fmArduinoSerialConnect_KeyUp(object sender, KeyEventArgs e)
        {
            if ((e.KeyCode == Keys.W))
            {
                movingUp = false;
            }
            if (e.KeyCode == Keys.S)
            {
                movingDown = false;
            }
            if (e.KeyCode == Keys.A)
            {
                movingLeft = false;
            }
            if (e.KeyCode == Keys.D)
            {
                movingRight = false;
            }

            if (e.KeyCode == Keys.ControlKey) isCtrlPressed = false;
            if (e.KeyCode == Keys.E) isEPressed = false;
            if (e.KeyCode == Keys.ShiftKey) isShiftPressed = false;
        }

        // A specific event when pressed a certain key is entered
        private void fmArduinoSerialConnect_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (e.KeyChar == 'b')
            {
                ShootBullet();
            }
            if (e.KeyChar == 'p')
            {
                tmrMain.Stop();
            }
            if (e.KeyChar == 'p')
            {
                tmrMain.Start();
            }
        }

        private void MoveEnemies()
        {
            for (int i = enemies.Count - 1; i >= 0; i--)
            {
                enemies[i].Move();
                if (enemies[i].EnemyPicture.Bounds.IntersectsWith(pbxFlakDdeb.Bounds))
                {
                    loseLife();
                    return;
                }

                if (enemies[i].IsOffScreen(this.Width))
                {
                    enemies[i].Remove(this);
                    enemies.RemoveAt(i);
                    SpawnEnemies();
                    loseLife(); 
                }

            }

        }
        private void SpawnEnemies()
        {

            while (enemies.Count < 10)
            {
                int randomY = random.Next(50, tbpCustomApplication.Height - 20);
                int randomX = random.Next(-200, -40);

                int type = random.Next(3);

                Enemy newEnemy;

                switch (type)
                {
                    case 1:
                        newEnemy = new Fast(tbpCustomApplication, randomY, randomX);
                    break;
                    case 2:
                        newEnemy = new Slow(tbpCustomApplication, randomY, randomX);
                    break;
                    default:
                        newEnemy = new Enemy(tbpCustomApplication, randomY, randomX, 1);
                    break;
                }

                enemies.Add(newEnemy);
            }
        }

        private void MoveBullets()
        {
            for(int i = bullets.Count - 1; i >= 0; i--)
            {
                bullets[i].Move();

                // Remove the bullet when it's outside the screen
                if (bullets[i].BulletPicture.Left < 0)
                {
                    tbpCustomApplication.Controls.Remove(bullets[i].BulletPicture);
                    bullets[i].BulletPicture.Dispose();
                    bullets.RemoveAt(i);
                }
            }
        }

        private void ShootBullet()
        {
            Bullet bullet = new Bullet(tbpCustomApplication, pbxFlakDdeb.Left, pbxFlakDdeb.Top + pbxFlakDdeb.Height / 4, bulletSpeed);
            bullets.Add(bullet);

            SoundPlayer player = new SoundPlayer("C:/Users/domin/OneDrive/Pictures/AUDIO/retro-laser-2-236680.wav");
            player.Play();

            shotsFired++;
        }

        private void DetectBulletCollison()
        {
            for (int i = bullets.Count - 1; i >= 0; i--)
            {
                for (int j = enemies.Count - 1;  j >= 0; j--)
                {
                    if (bullets[i].BulletPicture.Bounds.IntersectsWith(enemies[j].EnemyPicture.Bounds))
                    {
                        enemies[j].Remove(this);
                        enemies.RemoveAt(j);
                        enemiesHit++;

                        bullets[i].BulletPicture.Dispose();
                        bullets.RemoveAt(i);
                        break;
                    }
                }
            }
        }
        private void RespawnPlayer()
        {
            pbxFlakDdeb.Left = tbpCustomApplication.Width - 100;
            pbxFlakDdeb.Top = tbpCustomApplication.Height / 2;

            for (int i = enemies.Count - 1; i >= 0; i--)
            {
                if (enemies[i].EnemyPicture.Left >= pbxFlakDdeb.Left - 100)
                {
                    enemies[i].Remove(this);
                    enemies.RemoveAt(i);
                }
            }
        }

        private void btnGameStartDdeb_Click(object sender, EventArgs e)
        {
            tmrMain.Start();
        }

        private void btnGameResetDdeb_Click(object sender, EventArgs e)
        {
            tmrMain.Stop();
            ResetGame();
        }

        private void ResetGame()
        {
            playerLives = 3;
            RespawnPlayer();
            ClearAllEnemies();

            movingUp = false;
            movingDown = false;
            movingRight = false;
            movingLeft = false;

            shotsFired = 0;
            lblBulletsFiredDdeb.Text = "-";

            enemiesHit = 0;
            lblEnemiesShotDdeb.Text = "-";

            Accuracy = 0;
            lblAccuracyDdeb.Text = "-";
        }

        private void loseLife()
        {
            playerLives--;

            switch (playerLives)
            {
                case 0:
                    pbxPlayerLive1.BackColor = Color.Gray;
                    GameOver();
                    break;
                case 1:
                    RespawnPlayer();
                    pbxPlayerLive3.BackColor = Color.Gray;
                    break;
                case 2:
                    RespawnPlayer();
                    pbxPlayerLive2.BackColor = Color.Gray;
                    break;
                default:
                    break;
            }
        }

        private void GameOver()
        {
            tmrMain.Stop();
            if (DialogResult.Yes == MessageBox.Show("You lost, try again?", "Game Over", MessageBoxButtons.YesNo, MessageBoxIcon.Exclamation))
            {
                
                ResetGame();
                playerLives = 3;
                pbxPlayerLive1.BackColor = Color.Red;
                pbxPlayerLive2.BackColor = Color.Red;
                pbxPlayerLive3.BackColor = Color.Red;
            }
            else
            {
                Application.Exit();
            }
        }
        // This method removes all active enemies from the screen and clears the enemies list.
        private void ClearAllEnemies()
        {
            foreach (var enemy in enemies)
            {
                enemy.Remove(this);
            }
            enemies.Clear();
        }

        #endregion

        //THIS WAY THE REGION BOUNDARIES CAN BE FOUND EASIER

    }
}
